local PANEL = {};

// arrow material.
local arrow = surface.GetTextureID( "gui/arrow" );

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// init
function PANEL:Init( )
	// linked calss
	self.LinkedClass = nil;
	
	// values
	self.Minimum = 0;
	self.Maximum = 100;
	self.Value = -1;
	
	// bar.
	self.Vertical = true;
	self.BarSize = 24;
	self.BarPos = 0;
	self.Highlight = false;
	self.LastValue = 0;
	self.SnapsTo = 8;
	self.Text = "No Name";
	self.NextConVarCheck = CurTime() + 2;
	
	// dragging.
	self.DragInfo = {
		dragging = false,
		barstart = 0,
		dragstart = 0,
	};
	
	//?
	self:SetMouseInputEnabled( true );
	
end

// set snap
function PANEL:SetSnap( v )
	self.SnapsTo = v;
	
end

function PANEL:Think( )
	// dont' do shit unless we're attached to a convar.
	if( !self.ConVar ) then return; end

	// time to update?
	if( self.NextConVarCheck <= CurTime() && !self.Grabbed ) then
		// next
		self.NextConVarCheck = CurTime() + 2;
		
		// update.
		local val = GetConVarNumber( self.ConVar );
		
		// differs?
		if( self.Value != val ) then
			self:SetValue( val );
			self.LastValue = val;
		
		end
	
	end
	
end


// cursor enter
function PANEL:OnCursorEntered( )
	self.Highlight = true;
end

function PANEL:OnCursorExited( )
	self.Highlight = false;
	
end

// set range
function PANEL:SetRange( mins, maxs )
	self.Minimum = mins;
	self.Maximum = maxs;
	
	// clamp value
	self.Value = ( math.Clamp( self.Value, mins, maxs ) );
	
end

// set value
function PANEL:SetValue( v )
	// 
	self.Value = v;
	
	// clamp
	self.Value = ( math.Clamp( self.Value, self.Minimum, self.Maximum ) );
	
	// update bar.
	self:CalculatePosFromValue();
	
	// call
	self:GetParent():ScrollValueChanged( self.Value );

	
end

// get value
function PANEL:GetValue( )
	return self.Value;
	
end

// set horizontal
function PANEL:SetHorizontal( v )
	self.Vertical = !v;
	
end


// mouse pressed
function PANEL:OnMousePressed( mc )
	// fetch mouse
	local x, y = gui.MousePos();
	x, y = self:ScreenToLocal( x, y );
	
	// within the bar?
	if( self.Vertical && y > self.BarPos && y < self.BarPos + self.BarSize ) then
		// start drag
		self.DragInfo.dragging = true;
		self.DragInfo.dragstart = y;
		self.DragInfo.barstart = self.BarPos;
	
		// capture the mouse
		self:MouseCapture( true );
		
	elseif( !self.Vertical && x > self.BarPos && x < self.BarPos + self.BarSize ) then
		// start drag
		self.DragInfo.dragging = true;
		self.DragInfo.dragstart = x;
		self.DragInfo.barstart = self.BarPos;
	
		// capture the mouse
		self:MouseCapture( true );
		
	end
	
end

// mouse released
function PANEL:OnMouseReleased( mc )
	// stop the drag
	self.DragInfo.dragging = false;	

	// release the mouse
	self:MouseCapture( false );
	
end



// calc pos from value
function PANEL:CalculatePosFromValue( )
	// calc size
	local size = self:GetTall() - self.BarSize;
	if( !self.Vertical ) then size = self:GetWide() - self.BarSize; end
	
	// calculate position from value.s
	self.BarPos = ( size / ( self.Maximum - self.Minimum ) ) * ( self.Value - self.Minimum );
	
end

// calc value
function PANEL:CalculateValue( )
	// calc size
	local size = self:GetTall() - self.BarSize;
	if( !self.Vertical ) then size = self:GetWide() - self.BarSize; end
	
	// set value
	self.Value = self.Minimum + ( ( self.Maximum - self.Minimum ) / size ) * self.BarPos;
	
	// snap value.
	self.Value = self.Value - math.fmod( self.Value, self.SnapsTo );
	
	// call
	self:GetParent():ScrollValueChanged( self.Value );
	
	// our value changed?
	if( self.LastValue != self.Value ) then
		self.LastValue = self.Value;
		
		// convar?
		if( self.ConVar ) then
			LocalPlayer():ConCommand( self.ConVar .. " " .. self.Value .. "\n" );
		
		end
		
		// call event
		if( self.LinkedClass ) then
			self.LinkedClass:CallEvent( "OnSliderMoved", self.Value );
			
		end
	
	end
	
	// update position.
	self:CalculatePosFromValue();
	
end

// mouse moved.
function PANEL:OnCursorMoved( x, y )
	// not dragging?
	if( !self.DragInfo.dragging ) then return; end
	
	// calc size
	local size = self:GetTall() - self.BarSize;
	if( !self.Vertical ) then size = self:GetWide() - self.BarSize; end
	
	// vertical
	if( self.Vertical ) then
		// calc new pos.
		local y = self.DragInfo.barstart + ( y - self.DragInfo.dragstart );
		
		// clamp.
		if( y > size ) then y = size; end
		if( y < 0 ) then y = 0; end
		
		// set pos
		self.BarPos = y;
	
	// horizontal	
	else
		// calc new pos.
		local x = self.DragInfo.barstart + ( x - self.DragInfo.dragstart );
		
		// clamp.
		if( x > size ) then x = size; end
		if( x < 0 ) then x = 0; end
		
		// set pos
		self.BarPos = x;
		
	end
	
	// update
	self:CalculateValue();
	
end

// paint
function PANEL:Paint( )
	// drag the slider!!!	
	surface.SetTexture( arrow );
	local delta = 0;
	if( self.Pulse || self.DragInfo.dragging ) then delta = 128; end
	surface.SetDrawColor( 255, 255, 255, 127 + delta );
	

	// vertical
	if( self.Vertical ) then
		surface.DrawTexturedRectRotated(
			( self:GetWide() * 0.5 )  + ( self.BarSize * 0.5 ), ( self.BarPos ) + ( self.BarSize * 0.25 ),
			self.BarSize * 0.75, self.BarSize,
			90
			
		);
		
	// horizontal.
	else
		surface.DrawTexturedRectRotated(
			( self.BarPos ) + ( self.BarSize * 0.5 ), ( self:GetTall() * 0.5 ) + ( self.BarSize * 0.25 ),
			self.BarSize, self.BarSize * 0.75,
			0
			
		);
		
		// draw text and value.
		draw.SimpleText(
			self.Text,
			"Default",
			( self.BarSize * 0.5 ), 0,
			AppFramework:Theme().colors['text'],
			TEXT_ALIGN_LEFT,
			TEXT_ALIGN_TOP
		);
		draw.SimpleText(
			self.Value,
			"DefaultSmall",
			self:GetWide() - ( self.BarSize * 0.5 ), 0,
			AppFramework:Theme().colors['text'],
			TEXT_ALIGN_RIGHT,
			TEXT_ALIGN_TOP
		);
		
	end

	//
	return true;
	
end


// register
vgui.Register( "ctl_slider_slider", PANEL, "Panel" );



// track.
local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end


// scrollbar.
function PANEL:Init( )
	// linked class.
	self.LinkedClass = nil;
	
	// vertical
	self.Vertical = true;
	
	// slider?
	self.Slider = vgui.Create( "ctl_slider_slider", self );
	
end

// I really hate this.
function PANEL:ScrollValueChanged( v )
	// call event
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnSliderMoved", self.Slider:GetValue(), self );
		
	end

end

// perform layout
function PANEL:PerformLayout( )
	// vertical
	if( self.Vertical ) then
		self.Slider:SetPos( 0, 0 );
		self.Slider:SetSize( 32, self:GetTall() );

	// horizontal.
	else
		self.Slider:SetPos( 0, 0 );
		self.Slider:SetSize( self:GetWide(), 32 );

	end
	
end

// set horizontal
function PANEL:SetHorizontal( v )
	self.Vertical = !v;
	self.Slider:SetHorizontal( v );
	
end

// paint
function PANEL:Paint( )
	// vertical
	if( self.Vertical ) then
		AppFramework:Theme():DrawFrame( self:GetWide() * 0.5 - 4, ( self.Slider.BarSize * 0.5 ), 8, self:GetTall() - ( self.Slider.BarSize ), FRAME_INSET );
		
	// horizontal
	else
		AppFramework:Theme():DrawFrame( ( self.Slider.BarSize * 0.5 ), self:GetTall() * 0.5 - 4, self:GetWide() - ( self.Slider.BarSize ), 8, FRAME_INSET );
	
	end
	
	//
	return true;
	
end

// set range
function PANEL:SetRange( mi, ma )
	self.Slider:SetRange( mi, ma );
	
end

// set value
function PANEL:SetValue( v )
	self.Slider:SetValue( v );
	
end

// get value
function PANEL:GetValue( )
	return self.Slider:GetValue();
	
end

// register
vgui.Register( "ctl_slider", PANEL, "Panel" );



// create app framework control.
CtlSlider_class 	= Control_class:create( nil, false, "ctl_slider" );


// set range
function CtlSlider_class:SetRange( mi, ma )
	self:GetHandle().Slider:SetRange( mi, ma );
	
end

// set value
function CtlSlider_class:SetValue( v )
	self:GetHandle().Slider:SetValue( v );
	
end

// get value
function CtlSlider_class:GetValue( )
	return self:GetHandle().Slider:GetValue();
	
end

// set horizontal
function CtlSlider_class:SetHorizontal( v )
	self:GetHandle():SetHorizontal( v );
	
	
end


// set value
function CtlSlider_class:SetText( v )
	self:GetHandle().Slider.Text = v;
	
end

// set value
function CtlSlider_class:SetConVar( v )
	self:GetHandle().Slider.ConVar = v;
	
end

// set value
function CtlSlider_class:SetSnap( v )
	self:GetHandle().Slider:SetSnap( v );
	
end

